### 数据结构

``` shell
typedef struct {
    unsigned lcore_id;					
    unsigned int delay_µs;				
    uint16_t portid;					
    uint64_t sync_interval;				
    struct rte_mempool *mbuf_pool;		
    struct rte_ring *tx_ring;			
    struct rte_ring *rx_ring;			
    struct rte_timer sync_timer;		
} DpdkEthercat;
``` 
---
### 数据字段
``` shell
unsigned lcore_id;					
unsigned int delay_µs;
uint16_t portid;
uint64_t sync_interval;
struct rte_mempool *mbuf_pool;		
struct rte_ring *tx_ring;			
struct rte_ring *rx_ring;				
struct rte_timer sync_timer;			
```
---
### 详细说明
描述了DPDK-Ethercat网口的结构特征

#### 数据结构文档

- **lcore_id**

    unsigned lcore_id

    DPDK绑定的CPU核心
_________________

- **delay_µs**

    unsigned int delay_µs

    PMD模式下轮询延时
_________________

- **portid**

    uint16_t portid
				
    DPDK绑定的网口
_________________

- **sync_interval**

    uint64_t sync_interval		

    Ethercat应用模式下同步周期
_________________

- **mbuf_pool**	

    struct rte_mempool *mbuf_pool	

    DPDK内存池
_________________

- **tx_ring**	

    struct rte_ring *tx_ring	
    
    DPDK发送的数据包
_________________

- **rx_ring**

    struct rte_ring *rx_ring		

    DPDK接收的数据包
_________________

- **sync_timer**

    struct rte_timer sync_timer		

    Ethercat应用模式同步定时器
_________________